package gov.va.med.mhv.vitals.validator;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.util.MessagesUtil;

@Component
public class PainValidator extends Validator{
	

	private static final int COMMENTS_MAX_LENGTH = 255;
	private static final Integer PAINLEVEL_MIN_VALUE = new Integer("0");
	private static final Integer PAINLEVEL_MAX_VALUE = new Integer("10");
	private static final String PAIN_LEVEL ="Pain Level";

	
	@Autowired
	private MessagesUtil messages;
	
	public void painValidations(ResponseUtil response, PainReadingDTO paindto) {
		fieldValidation(response, paindto);
	}

	private void fieldValidation(ResponseUtil response, PainReadingDTO paindto) {
		validateComments(response,paindto);
		validatePainLevel(response,paindto);
		validateDateEntered(response,paindto);
		validateUserProfile(response,paindto);
	}

	private void validateUserProfile(ResponseUtil response,	PainReadingDTO paindto) {
		if( paindto.getUserprofileId() == null ) {
			response.getValidationErrors().put("userProfile", "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(paindto.getUserprofileId());
		if ( !valid) {
			response.getValidationErrors().put("userProfile", "userProfile is Invalid");
		}
		
	}

	private void validateDateEntered(ResponseUtil response,	PainReadingDTO paindto) {
		Date value = paindto.getReading();
		if( value == null ) {
			Validations.validateRequired("dateEntered", value, response.getValidationErrors());
			return;
		}		
	}

	private void validatePainLevel(ResponseUtil response, PainReadingDTO paindto) {
		Integer value = paindto.getPainLevel();
		if( value == null ) {
			Validations.validateRequired(PAIN_LEVEL, value, response.getValidationErrors());
			return;
		}		
		Validations.validateMinValue("painminimum", value, PAINLEVEL_MIN_VALUE,PAIN_LEVEL, response.getValidationErrors());
		Validations.validateMaxValue("painmaximum",value, PAINLEVEL_MAX_VALUE,PAIN_LEVEL,response.getValidationErrors());
	}

	private void validateComments(ResponseUtil response, PainReadingDTO paindto) {
		String value = paindto.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength("comments",value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}

}
